﻿//|---------------------------------------------------------------|
//|                         SORT DEMO                             |
//|         Developed by Yewondwossen Tadesse(Wonde)              |  
//|                               Copyright ©  2011               |
//|---------------------------------------------------------------|
//|                         SORT DEMO                             |
//|---------------------------------------------------------------|
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SortLibray;

namespace SortDemo
{
    public partial class GridViewSortDemo : System.Web.UI.Page
    {
        ///
        /// Get or set GridView SortExpression in a viewstate
        /// 
        public string GridViewSortExpression
        {
            get
            {
                if (ViewState[Constants.SORT_EXPRESSION] != null)
                    return ViewState[Constants.SORT_EXPRESSION].ToString();
                return Constants.PLOT_NUMBER; // Set PlotNumber as a default expression
            }
            set
            {
                ViewState[Constants.SORT_EXPRESSION] = value;
            }
        }

        ///
        /// Get or set GridView SortDirection in a viewstate
        /// 
        public SortDirection GridViewSortDirection
        {
            get
            {
                if (ViewState[Constants.SORT_DIRECTION] != null)
                    return (SortDirection)ViewState[Constants.SORT_DIRECTION];
                return SortDirection.Ascending; // return Ascending order
            }
            set
            {
                ViewState[Constants.SORT_DIRECTION] = value;
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
                bindGridView();
        }

        protected void gvPlots_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            gvPlots.PageIndex = e.NewPageIndex;
            bindGridView();
        }

        protected void gvPlots_Sorting(object sender, GridViewSortEventArgs e)
        {
            GridViewSortExpression = e.SortExpression;
            if (GridViewSortDirection == SortDirection.Ascending)
                GridViewSortDirection = SortDirection.Descending;
            else
                GridViewSortDirection = SortDirection.Ascending;
            bindGridView();
        }

        /// <summary>
        /// Bind GridView to a DataSource
        /// </summary>
        private void bindGridView()
        {
            try
            {
                Plots plots = new Plots();
                if (cbCharactorComparer.Checked) // Use the Character Comparer
                {
                    if (GridViewSortExpression.ToLower().Equals(Constants.PLOT_NUMBER.ToLower()))
                        plots.SortedList(GridViewSortDirection, new PlotNumberComparer(), cbCaseSensitivity.Checked);
                    else
                        plots.SortedList(GridViewSortExpression, GridViewSortDirection, cbCaseSensitivity.Checked);
                    gvPlots.DataSource = plots;
                    gvPlots.DataBind();
                }
                else // Use built in Linq Sort mechanism 
                {
                    List<Plot> sortResult = plots;
                    switch (GridViewSortExpression)
                    {
                        case Constants.PLOT_NUMBER:
                            sortResult = plots.OrderBy(p => p.PlotNumber).ToList();
                            break;
                        case Constants.AREA_CODE:
                            sortResult = plots.OrderBy(p => p.AreaCode).ToList();
                            break;
                        case Constants.AREA:
                            sortResult = plots.OrderBy(p => p.Area).ToList();
                            break;
                        case Constants.PERIMETER:
                            sortResult = plots.OrderBy(p => p.Perimeter).ToList();
                            break;
                        default:
                            sortResult = plots.OrderBy(p => p.PlotNumber).ToList();
                            break;
                    }
                    if (GridViewSortDirection == SortDirection.Descending)
                        sortResult.Reverse();
                    gvPlots.DataSource = sortResult;
                    gvPlots.DataBind();
                }
            }
            catch (Exception exception)
            {
                Response.Write(exception.Message);
            }
        }
    }
}